REBOL [
    subject: "liste des biens"
]

print "Content-type: text/html^/"

data: make object! decode-cgi system/options/cgi/query-string

style: to-integer data/style
nbr-chambres: to-integer data/chambres
budget-min: to-integer data/budgetmin
budget-max: to-integer data/budgetmax
zone: to-integer data/zone

conn: open odbc://immobiliernet
p: first conn

insert p [ {
    SELECT num,adr1,ville,prix 
    FROM affaires 
    WHERE zonegeo = ?
    AND style = ?        
    AND chambres >= ?
    AND ((prix >= ? ) AND (prix <= ?))
    AND vendue = 0
    ORDER BY ville
    } zone style nbr-chambres budget-min budget-max 
]


maisons: copy p
close p
close conn

print {
<HTML>
<HEAD><TITLE>Catalogue ImmobilierNet</TITLE></HEAD>
<BODY BGCOLOR="#FFFFFF">
<IMG src="logo.gif"><BR>
<UL>
<IMG src="puce.gif">
Rponses du catalogue :<BR><BR>
<CENTER>
<TABLE width=400 border=0><TR bgcolor="#C0C0C0" align="center">
<TD>Dossier</TD>
<TD>Rue</TD>
<TD>Ville</TD>
<TD>Prix</TD>
</TR>
}

p: 0
couleurs: [ "#FFC0C0" "C0FFC0" ]
foreach m maisons [
    print join {<TR bgcolor="} [ (pick couleurs (p + 1)) {" align="center">}]
    p: 1 - p
    print join {<TD><A href=description.cgi?num=} [ m/1 ">" m/1 "</A></TD>"]
    for i 2 4 1 [
        print join "<TD>" [ m/:i "</TD>" ]
    ]
    print "</TR>"
]

print {
</TABLE></CENTER>
</UL>
</BODY>
</HTML>
}
